<?php 	session_start(); ?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="initial-scale=1.0, user-scalable=no">
	<meta name="apple-mobile-web-app-capable" content="yes">
	<meta name="apple-mobile-web-app-status-bar-style" content="black">
	<title>Parking Ibiza</title>
  
  	<link rel="stylesheet" href="https://code.jquery.com/mobile/1.4.0/jquery.mobile-1.4.0.min.css"/>
	<link rel="stylesheet" href="themes/Tisa.min.css" />
	<link rel="stylesheet" href="http://code.jquery.com/mobile/1.4.0/jquery.mobile.structure-1.4.0.min.css" />
  	<script src="https://code.jquery.com/jquery-1.10.2.min.js"></script>
	<script src="https://code.jquery.com/mobile/1.4.0/jquery.mobile-1.4.0.min.js"></script>
	
</head>
<body>
	
<!-- Home -->
<div data-role="page" id="tareas">
	<script type="text/javascript">
		var usuario = '<?php echo str_replace('\\', '\\\\',$_SESSION['user']); ?>';
		var ubicOri= new Array();
		var codCli=new Array();
		var today;
		$(document).ready( function() {
		    var now = new Date();
//			var siguiente =document.getElementById("siguiente");
	//		var anterior = document.getElementById("anterior");
		    var day = ("0" + now.getDate()).slice(-2);
		    var month = ("0" + (now.getMonth() + 1)).slice(-2);
		    today = now.getFullYear()+"-"+(month)+"-"+(day);
			$('#fechaid').val(today);
		   load_rows();  
		   $("#fechaid").on("change keyup paste", function(){
				load_rows();   
			})
			
		});
		
		function limpiar_tareas(){
			document.getElementById("tarea").innerHTML = "";
		}
		
		function volver_pendiente(id){
			var xhr = new XMLHttpRequest();
			xhr.onload= function() {
				if(this.responseText=='1'){
					load_rows();		
				}
			}
			xhr.open('POST','ajax.php',true);
			xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
			xhr.send("method=pendiente&var="+id);
		}
		
		function completar(id,tarea,matricula){
			var datos=new Array();
			datos[0]=id;		//Identificador tarea
			datos[1]=usuario;	//Usuario del sistema
			datos[2]=document.getElementById("ubicacion"+tarea).value;
			datos[3]=matricula;
			datos[4]=ubicOri[tarea];
			datos[5]=codCli[tarea];
			var xhr = new XMLHttpRequest();
			xhr.onload= function() {
				if(this.responseText=='1'){
				
					load_rows();		
				}
			}
			xhr.open('POST','ajax.php',true);
			xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
			xhr.send("method=completar&var="+datos);
		}
		function loadUbics(id,ubic){
			var xhr = new XMLHttpRequest();
			xhr.onload= function() {
				var response=JSON.parse(this.responseText);
				var ubics=response[0];	
				var select =document.getElementById("ubicacion"+id);
				for (i=0; i<ubics.length; i++) {
					opt = document.createElement('option');
					opt.value = ubics[i];
					opt.innerHTML = ubics[i];
					select.appendChild(opt);
				}
				// Grab a select field
				var el = $('#ubicacion'+id);
				// Select the relevant option, de-select any others
				el.val(ubic).attr('selected', true).siblings('option').removeAttr('selected');
				// jQM refresh
				el.selectmenu("refresh", true);
			}
			xhr.open('POST','ajax.php',true);
			xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
			xhr.send("method=ubics");
		}		
		function check_alerta(matricula,id){
			var xhr = new XMLHttpRequest();
			xhr.onload= function() {
				if (this.responseText!='0'){
					var alerta =document.getElementById("alerta"+id);
					var orden = document.getElementById("orden"+id);
					orden.innerHTML='<strong>Orden reparación:</strong> '+this.responseText;
					/*alerta.src="images/warn.png";
					alerta.style.width="20px";
					alerta.style.heigth="20px";*/
					alerta.style.visibility = 'visible';
				}
				/*else{
					var alerta =document.getElementById("alerta"+id);
					alerta.style.visibility = 'hidden';
				}*/
			}
			xhr.open('POST','ajax.php',true);
			xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
			xhr.send("method=alerta&var="+matricula);
			
		}
		
		
		function check_pendientes(hoy){
			//var fecha = new Date(document.getElementById("fechaid").value);
			var newDate = new Date(hoy.getFullYear(), hoy.getMonth(), hoy.getDate()-1);
			var day = ("0" + newDate.getDate()).slice(-2);
		    var month = ("0" + (newDate.getMonth() + 1)).slice(-2);
		    var ayer = newDate.getFullYear()+"-"+(month)+"-"+(day) ;
			var xhr = new XMLHttpRequest();
			xhr.onload= function() {
				var pendientes =document.getElementById("pendientes");
				if (this.responseText!='0'){
					pendientes.innerHTML='<strong><img src="images/warn.png" width="20px" heigth="20px"/>¡Hay '+this.responseText+' tareas pendientes de ayer!</strong> ';
				}
				else{
					pendientes.innerHTML='';
				}
			}
			xhr.open('POST','ajax.php',true);
			xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
			xhr.send("method=pendientes_ayer&var="+ayer);
		  
		}
		
		function load_rows(){
			check_pendientes(new Date(today));
	  		var xhr = new XMLHttpRequest();
	  		var fecha=$('#fechaid').val();
			xhr.onload= function() {
			//console.log(this.responseText);
				var response=JSON.parse(this.responseText);	//response[0]: Matricula //response[1]: Tarea //response[2]: Hora //response[3]: Cerrado //response[4]: Descripción vehículo
				limpiar_tareas();							//response[5]: Descripción //response[6]: Ubicación //response[7]: Contacto //response[8]: Nombre //response[9]: teléfono (quitado)
				if(!response[0]){							//response[10]: Identificador //response[11]: Parking recomendado
					$('<h2><center>No hay tareas pendientes</center></h2>').appendTo($('#tarea'));
				}
				else{
					for(var i=0;i<response[0].length;i++){
						ubicOri[i]=response[6][i];
						codCli[i]=response[7][i];
						$('<div id="tarea'+i+'" data-role="collapsible" data-collapsed="true"><h3 id="titulo'+i+'"><img id="alerta'+i+'" src="images/warn.png" style="height: 20px;	width:	20px;visibility: hidden;"/>  '+response[2][i]+' - '+response[1][i]+' </h3>'+
						'<span><strong>Matrícula:</strong> '+response[0][i]+'</span><br><span><strong>Descripción vehículo:</strong> '+response[4][i]+'</span>'+
						'<br><span><strong>Descripción:</strong> '+response[5][i]+'</span>'+
						'<br><span><strong>Contacto:</strong> '+response[7][i]+'</span><br><span><strong>Nombre:</strong> '+response[8][i]+'</span>'+
						'<br><span><strong>Aparcamiento rec.: </strong><span id="parkrec">'+response[11][i]+'</span></span><br><span>'+
						'<br><span id="orden'+i+'" style="color: #f00;"><span></div>').appendTo($('#tarea'));
						if(response[3][i]!='0'){
							var titulo=document.getElementById("titulo"+i);
							document.getElementById("tarea"+i).setAttribute("data-theme","c"); 
							$('<label for="ubicacion'+i+'"><strong>Ubicación: </strong></label><select id="ubicacion'+i+'" data-theme="a" data-mini="true"  disabled="true"></select>').appendTo($('#tarea'+i));
							$('<input type="button" value="Volver a pendientes" onclick="volver_pendiente(\''+response[10][i]+'\');"/>').appendTo($('#tarea'+i));
							
						}
						else{
							var titulo=document.getElementById("titulo"+i);
							document.getElementById("tarea"+i).setAttribute("data-theme","d"); 
							$('<label for="ubicacion'+i+'"><strong>Ubicación: </strong></label><select id="ubicacion'+i+'" data-theme="a" data-mini="true"></select>').appendTo($('#tarea'+i));
							$('<input type="button"  value="Completar" onclick="completar(\''+response[10][i]+'\','+i+',\''+response[0][i]+'\');"/>').appendTo($('#tarea'+i));
						}						
						$('#tarea').find('div[data-role=collapsible]').collapsible(); 
						$('#tarea').find('select').selectmenu();
						$('#tarea').find('input[type=button]').button();
						loadUbics(i,response[6][i]);
						check_alerta(response[0][i],i);
					}
				}
			}
			xhr.open('POST','ajax.php',true);
			xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
			xhr.send("method=tareas&var="+fecha);
		  }
		  		  
		  function siguiente(){
			var fecha = new Date(document.getElementById("fechaid").value);
			var newDate = new Date(fecha.getFullYear(), fecha.getMonth(), fecha.getDate()+1);
			var day = ("0" + newDate.getDate()).slice(-2);
		    var month = ("0" + (newDate.getMonth() + 1)).slice(-2);
		    var today = newDate.getFullYear()+"-"+(month)+"-"+(day) ;
			$('#fechaid').val(today);
			load_rows();  
		  }
		  
		  function anterior(){
			var fecha = new Date(document.getElementById("fechaid").value);
			var newDate = new Date(fecha.getFullYear(), fecha.getMonth(), fecha.getDate()-1);
			var day = ("0" + newDate.getDate()).slice(-2);
		    var month = ("0" + (newDate.getMonth() + 1)).slice(-2);
		    var today = newDate.getFullYear()+"-"+(month)+"-"+(day) ;
			$('#fechaid').val(today);
			load_rows();  
		  }
		  
 	</script>
    <div data-theme="a" data-role="header">
        <h3>
            PARKING IBIZA
		</h3>
	   	<a href="menu.php" data-icon="back" class="ui-btn-left">Volver</a>
    </div>
    <div data-role="content">
    	<center><h2>Tareas</h2></center>
		<center style="color:#F00"; id="pendientes"></center>
		<div class="ui-grid-b">
			<div class="ui-block-a">
				<a href="#" class="ui-btn ui-corner-all ui-shadow" onclick="anterior()"><</a><br>
			</div>
			<div class="ui-block-b">
				<input id="fechaid" type="date" data-mini="true" data-inline="true" style="margin-top: 15px;">
			</div>
			<div class="ui-block-c">
				<a href="#" class="ui-btn ui-corner-all ui-shadow" onclick="siguiente()">></a><br>
			</div>
		</div>

    	<div id="tarea"></div>
    </div>
</div>
</body>
</html>