<?php 	session_start(); ?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="initial-scale=1.0, user-scalable=no">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="apple-mobile-web-app-status-bar-style" content="black">
  <title>Parking Carrasco</title>
  <link rel="stylesheet" href="https://code.jquery.com/mobile/1.4.0/jquery.mobile-1.4.0.min.css"/>
	<link rel="stylesheet" href="themes/Tisa.min.css" />
	<link rel="stylesheet" href="http://code.jquery.com/mobile/1.4.0/jquery.mobile.structure-1.4.0.min.css" />
  <script src="http://code.jquery.com/jquery-1.10.2.min.js"></script>
  <script src="http://code.jquery.com/mobile/1.4.0/jquery.mobile-1.4.0.min.js"></script>
</head>
<body>
<?php 
	if($_SESSION['ip']!=$_SERVER['REMOTE_ADDR']){
	?>
	<div data-role="page" id="restricted">
		<div data-theme="b" data-role="header">
			<h3>
				PARKING IBIZA
			</h3>
		</div>
		<div data-role="content">
			<div data-role="content">
				<center><h2>Acceso restringido</h2><br></center>
				<a data-role="button" data-theme="b" href="index.php" data-icon="back" data-iconpos="left">Volver</a>
			</div>
		</div>
	</div>
	<?php
	}
	else{
?>
<!-- Home -->
<div data-role="page" id="page1">    
  <script type="text/javascript">
  
	matricula = getUrlVars()["matricula"];
	loadUbics();
	check_alerta(matricula);
	load_tareas(matricula);
	var usuario = '<?php echo str_replace('\\', '\\\\',$_SESSION['user']); ?>';
	
	function loadBack(){
		var backBtn =document.getElementById("backBtn");
		backBtn.href="vehiculos.php?field="+getUrlVars()["field"]+"&data="+getUrlVars()["data"];
	}
	
  	function guardarCambios(){
  		var form=document.forms["datos"];
  		var datos=new Array();
  		datos[0]=form[0].value;//matrícula
  		datos[1]=form[2].value;//Ubicación
  		datos[2]=form[3].value;//Bastidor
  		datos[3]=form[6].value;//Ult. ITV
  		datos[4]=form[7].value;//Cad. ITV
  		datos[5]=form[8].value;//Antigua ubicación
  		datos[6]=form[4].value;//Código cliente
		datos[7]=usuario; //Usuario del programa
  		var xhr = new XMLHttpRequest();
		xhr.onload= function() {
			if(this.responseText=="OK"){
				 $.mobile.changePage('#guardado', {
		            transition: 'pop',
		            changeHash: true,
		            role: 'dialog'
		        });
			}
			else{
				alert('Ha ocurrido un error');
			}
		}
		xhr.open('POST','ajax.php',true);
		xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xhr.send("method=guardar&var="+datos);
  	}   
  	
  	function getUrlVars() {
    	var vars = {};
	    var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m,key,value) {
	        vars[key] = value;
	    });
	    return vars;
	}
	
	function loadUbics(){
		var xhr = new XMLHttpRequest();
		xhr.onload= function() {
			var response=JSON.parse(this.responseText);
			var ubics=response[0];	
			var select =document.getElementById("selectmenu1");
			for (i=0; i<ubics.length; i++) {
				opt = document.createElement('option');
				opt.value = ubics[i];
				opt.innerHTML = ubics[i];
				select.appendChild(opt);
			}
			// Grab a select field
			var el = $('#selectmenu1');
			// Select the relevant option, de-select any others
			el.val(ubics[0]).attr('selected', true).siblings('option').removeAttr('selected');
			// jQM refresh
			el.selectmenu("refresh", true);
			getCarData();
		}
		xhr.open('POST','ajax.php',true);
		xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xhr.send("method=ubics");
	}
  	
  	function getCarData(){
		var xhr = new XMLHttpRequest();
		xhr.onload= function() {
			//var response=JSON.parse(this.responseText)[0];
			var response=this.responseText.split(",");
			if(response[0]!='' && response[0]!='undefined'){
				document.forms["datos"]["matricula"].value=response[0];
				document.forms["datos"]["descripcion"].value=response[1];
				document.forms["datos"]["bastidor"].value=response[7];
				document.forms["datos"]["cod-cliente"].value=response[2];
				document.forms["datos"]["nom-cliente"].value=response[4];
				document.forms["datos"]["ult-itv"].value=response[5].replace(/\./g,"-");
				document.forms["datos"]["cad-itv"].value=response[6].replace(/\./g,"-");
				document.forms["datos"]["ubicacion_original"].value=response[3];
				document.forms["datos"]["parcRec"].value=response[8];
				var el = $('#selectmenu1');
				el.val(response[3]).attr('selected', true).siblings('option').removeAttr('selected');
				el.selectmenu("refresh", true);
			}
			else{
				$.mobile.changePage('#not-found', {
		            transition: 'pop',
		            changeHash: true,
		            role: 'dialog'
		        });
			}
		}
		xhr.open('POST','ajax.php',true);
		xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xhr.send("method=vehiculo&var="+matricula);
	}
	
	function check_alerta(matricula){
		var xhr = new XMLHttpRequest();
		xhr.onload= function() {
			if (this.responseText!='0'){
				var alerta =document.getElementById("alerta");
				var orden = document.getElementById("orden");
				orden.innerHTML='<strong>Rep:</strong> '+this.responseText;
				alerta.src="images/warn.png";
				alerta.style.width="20px";
				alerta.style.heigth="20px";
			}				
		}
		xhr.open('POST','ajax.php',true);
		xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xhr.send("method=alerta&var="+matricula);
		
	}
	
	
	function load_tareas(matricula){
		var xhr = new XMLHttpRequest();
		//var fecha=$('#fechaid').val();
		xhr.onload= function() {
			var response=JSON.parse(this.responseText);	//response[0]: Date //response[1]: Tarea //response[2]: Hora 
			if(!response[0]){							
				console.log("No hay tareas");
			}
			else{
				for(var i=0;i<response[0].length;i++){
					var tarea = document.getElementById("tarea");
					tarea.innerHTML=tarea.innerHTML+'<strong>Tarea:</strong> '+response[1][i]+ '    -   ' +response[0][i] + '-' +response[2][i] + '<br>';
					var alerta =document.getElementById("alerta");
					if(alerta.innerHTML==""){
						alerta.src="images/warn.png";
						alerta.style.width="20px";
						alerta.style.heigth="20px";
					}
				}
			}
		}
		xhr.open('POST','ajax.php',true);
		xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xhr.send("method=tareas_vehic&var="+matricula);
	  }
	
  </script>
   
    <div data-theme="a" data-role="header" data-position="fixed">
        <h3>
            PARKING IBIZA
        </h3>
		<a id="backBtn" data-icon="back" class="ui-btn-left">Volver</a>
    </div>
    <div data-role="content">
        <form action="" name="datos">
			<img id="alerta" src=""/>
			<span id="orden" style="color: #f00;"></span><br>
			<span id="tarea" style="color: #f00;"></span>
            <div data-role="fieldcontain">
                <label for="textinput2">
                    Matrícula
                </label>
                <input name="matricula" id="textinput2" placeholder="" value="" type="text" readonly>
            </div>
            <div data-role="fieldcontain">
                <label for="textinput3">
                    Descripción
                </label>
                <input name="descripcion" id="textinput3" placeholder="" value="" type="text" readonly>
            </div>
            <div data-role="fieldcontain">
                <label for="selectmenu1">
                    Ubicación
                </label>
               <select id="selectmenu1" name="ubicacion" data-theme="a">
               </select>
            </div>
            <div data-role="fieldcontain">
                <label for="textinput4">
                    Nº Bastidor
                </label>
                <input name="bastidor" id="textinput4" placeholder="" value="" type="text">
            </div>
            <div data-role="fieldcontain">
                <label for="textinput5">
                    Cod. Cliente
                </label>
                <input name="cod-cliente" id="textinput5" placeholder="" value="" type="text" readonly>
            </div>
            <div data-role="fieldcontain">
                <label for="textinput6">
                    Nom. Cliente
                </label>
                <input name="nom-cliente" id="textinput6" placeholder="" value="" type="text" readonly>
            </div>
            <div data-role="fieldcontain">
                <label for="textinput7">
                    Fecha ult. ITV
                </label>
                <input name="ult-itv" id="textinput7" placeholder="" type="date">
            </div>
            <div data-role="fieldcontain">
                <label for="textinput8">
                    Fecha cad. ITV
                </label>
                <input name="cad-itv" id="textinput8" placeholder="" value="" type="date">
            </div>
			<div data-role="fieldcontain">
                <label for="textinput9">
                    Aparcamiento recomendado
                </label>
                <input name="parcRec" id="textinput9" placeholder="" value="" type="text" readonly style="color: blue;font-weight: bold;">
            </div>
            <center>
            <a data-role="button" data-inline="true" data-theme="a" href="#page1"
            data-icon="edit" data-iconpos="left" onclick="guardarCambios();">
                Guardar
            </a>
           	</center>
           	<input type="hidden" name="ubicacion_original"/>
        </form>
    </div>
    
    <div data-role="popup" id="load" data-overlay-theme="a" data-theme="none" data-position-to="window">
		<img src="images/ajax-loader.gif" />
	</div>
	
	
</div>
<div data-role="dialog" id="guardado" data-theme="a">
    <div data-role="content">
    	<center><p>Datos guardados correctamente.</p></center>
    	<center><a href="vehiculos.php"><button data-role="button" data-mini="true" data-theme="a" data-inline="true" >Aceptar</button></a></center>
    </div>
</div>

<script>
loadBack();
</script>


<?php } ?>
</body>
</html>
